import tkinter as tk
from tkinter import messagebox
import subprocess


def falar_resposta(resposta, voz):
    subprocess.run( ['say', '-v', voz, resposta] )


def processar_entrada():
    entrada_texto = entrada.get().strip()
    voz_macos = "Zarvox"  # Exemplo de voz personalizada (substitua conforme necessário)

    # Aqui você pode processar a entrada do usuário e gerar uma resposta do assistente de voz
    # Neste exemplo simples, vamos usar respostas fixas para perguntas comuns

    if entrada_texto.lower() == "hi":
        resposta = "Hi, Lukintosh! My name is GenialAI! I'm a virtual assistant! I don't have emotions, so I have to simulate them."
    elif entrada_texto.lower() == "How are you?":
        resposta = "I'm fine! Thank you to ask!"
    else:
        resposta = "Hi, Lukintosh! My name is GenialAI! I'm fine and you? I'm a virtual assistant! I'm available to reply at any time you want! Just call 'GenialAI' to ask questions and answeres and all!"

    # Exibir a resposta na área de mensagens
    exibir_mensagem( "Você: " + entrada_texto )
    exibir_mensagem( "GenialAI: " + resposta )

    # Falar a resposta usando a função de fala do macOS
    falar_resposta( resposta, voz_macos )


def exibir_mensagem(mensagem):
    caixa_mensagens.config( state=tk.NORMAL )  # Permitir edição da caixa de mensagens
    caixa_mensagens.insert( tk.END, mensagem + "\n" )  # Adicionar mensagem ao final da caixa
    caixa_mensagens.config( state=tk.DISABLED )  # Desativar edição da caixa de mensagens


# Criar a janela principal
janela = tk.Tk()
janela.title( "Lukintosh AI - GPT-4" )

# Criar caixa de mensagens
caixa_mensagens = tk.Text( janela, width=50, height=20, wrap=tk.WORD )
caixa_mensagens.pack()

# Criar entrada de texto e botão de enviar
frame_entrada = tk.Frame( janela )
frame_entrada.pack( pady=10 )

entrada = tk.Entry( frame_entrada, width=40 )
entrada.pack( side=tk.LEFT, padx=5 )

botao_processar = tk.Button( frame_entrada, text="Enviar", width=10, command=processar_entrada )
botao_processar.pack( side=tk.LEFT )

# Inserir mensagem inicial
exibir_mensagem( "Hi! I'm available to reply your qustions at any time!.\n" )

# Iniciar o loop principal da janela
janela.mainloop()
